import 'package:rad/rad.dart';
import 'package:rad/widgets_html.dart';

class UtilWidgets {
  static Widget preloader(String text, [String? id]) {
    return Division(
      id: id,
      className: 'h-full d-flex justify-content-center align-items-center animate__animated animate__fadeIn',
      child: Division(
        children: [
          const Division(className: 'preloader'),
          Division(
            className: 'p-10 font-size-12 text-muted animate__animated animate__pulse',
            innerText: text,
          )
        ],
      ),
    );
  }

  static Widget smallPreloader() {
    return const Division(
      className: 'animate__animated animate__fadeIn',
      child: Division(className: 'preloader small'),
    );
  }

  static Widget noResults() {
    return const Division(
      className: 'h-full d-flex justify-content-center align-items-center animate__animated animate__fadeIn',
      child: Division(
        children: [
          Division(
            className: 'p-10 text-center font-size-16',
            child: Idiomatic(className: 'fa fa-search'),
          ),
          Division(
            className: 'p-10 font-size-12 text-muted animate__animated animate__pulse',
            innerText: 'Apparently there are no matches to your search',
          )
        ],
      ),
    );
  }

  static Widget somethingWentWrong() {
    return const Division(
      className: 'h-full d-flex justify-content-center align-items-center animate__animated animate__fadeIn',
      child: Division(
        children: [
          Division(
            className: 'p-10 text-center font-size-16',
            child: Idiomatic(className: 'fa fa-exclamation-triangle'),
          ),
          Division(
            className: 'p-10 font-size-12 text-muted animate__animated animate__pulse',
            innerText: 'Something went wrong. Please try again later.',
          )
        ],
      ),
    );
  }
}
